import numpy as np
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# Enable LaTeX rendering in matplotlib
plt.rc('text', usetex=True)
plt.rc('font', family='serif')

# Define functions
def f(x):
    return np.exp(-(4 / 3) * np.pi * x**2)

def g(x):
    return np.exp(-(3 / 4) * np.pi * x**2)

def repeatedf(x, p):
    return sum(f(x + n * p) for n in range(-10, 11))

def repeatedg(x, p):
    return sum(g(x + n * p) for n in range(-10, 11))

# Create plots
x = np.linspace(-10, 10, 1000)

# Plot f(x)
fig = plt.figure(figsize=(10, 8))
gs = GridSpec(2, 4, figure=fig)
ax1 = fig.add_subplot(gs[0, 0])
ax1.plot(x, f(x), color="blue", label="f(x)")
ax1.set_title(r"$x(t)$", fontsize=14)
ax1.grid()

# Plot repeatedf(x, p=5)
ax2 = fig.add_subplot(gs[0, 1])
ax2.plot(x, [repeatedf(xi, 5) for xi in x], color="blue", label="repeatedf")
ax2.set_title(r"$y(t)$", fontsize=14)
ax2.grid()

# Plot discretef using a stem plot
discretef_x = np.arange(-10, 10, 1/3)
discretef_y = f(discretef_x)
ax3 = fig.add_subplot(gs[0, 2])
ax3.stem(discretef_x, discretef_y, linefmt="blue", markerfmt="bo", basefmt=" ", label="discretef")
ax3.set_title(r"$x(n)$", fontsize=14)
ax3.grid()

# Plot discreterepeatedf using a stem plot
discreterepeatedf_x = np.arange(-12, 12, 1/4)
discreterepeatedf_y = [repeatedf(xi, 11/4) for xi in discreterepeatedf_x]
ax4 = fig.add_subplot(gs[0, 3])
ax4.stem(discreterepeatedf_x, discreterepeatedf_y, linefmt="blue", markerfmt="bo", basefmt=" ", label="discreterepeatedf")
ax4.set_title(r"$y(n)$", fontsize=14)
ax4.grid()

# Plot g(x)
ax5 = fig.add_subplot(gs[1, 0])
ax5.plot(x, g(x), color="red", label="g(x)")
ax5.set_title(r"$X(j\omega)$", fontsize=14)
ax5.grid()

# Plot discreteg using a stem plot
discreteg_x = np.arange(-10, 10, 1/5)
discreteg_y = g(discreteg_x)
ax6 = fig.add_subplot(gs[1, 1])
ax6.stem(discreteg_x, discreteg_y, linefmt="red", markerfmt="ro", basefmt=" ", label="discreteg")
ax6.set_title(r"$|c_\mu|$", fontsize=14)
ax6.grid()

# Plot repeatedg(x, p=3)
ax7 = fig.add_subplot(gs[1, 2])
ax7.plot(x, [repeatedg(xi, 3) for xi in x], color="red", label="repeatedg")
ax7.set_title(r"$X(e^{j\Omega})$", fontsize=14)
ax7.grid()

# Plot discreterepeatedg using a stem plot
discreterepeatedg_x = np.arange(-12, 12, 4/11)
discreterepeatedg_y = [repeatedg(xi, 4) for xi in discreterepeatedg_x]
ax8 = fig.add_subplot(gs[1, 3])
ax8.stem(discreterepeatedg_x, discreterepeatedg_y, linefmt="red", markerfmt="ro", basefmt=" ", label="discreterepeatedg")
ax8.set_title(r"$Y(\mu)$", fontsize=14)
ax8.grid()

# Show all plots
plt.tight_layout()
plt.show()

# Save the figure as a GIF
fig.savefig("fourier_relations.png")
